SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for cms_ad
-- ----------------------------
DROP TABLE IF EXISTS `cms_ad`;
CREATE TABLE `cms_ad` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0',
  `name` varchar(50) DEFAULT '',
  `pic` varchar(255) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `ordnum` int(10) unsigned DEFAULT '0',
  `isshow` smallint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_ad_group
-- ----------------------------
DROP TABLE IF EXISTS `cms_ad_group`;
CREATE TABLE `cms_ad_group` (
  `gid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gname` varchar(50) DEFAULT '',
  `gnum` int(10) DEFAULT '0',
  `gkey` varchar(50) DEFAULT '',
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_admin
-- ----------------------------
DROP TABLE IF EXISTS `cms_admin`;
CREATE TABLE `cms_admin` (
  `adminid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `adminname` varchar(50) DEFAULT '',
  `adminpass` varchar(50) DEFAULT '',
  `penname` varchar(20) DEFAULT '',
  `pid` int(10) DEFAULT '0',
  `logintimes` int(10) DEFAULT '0',
  `lastlogindate` bigint(10) DEFAULT '0',
  `lastloginip` varchar(50) DEFAULT '',
  `readonly` smallint(1) DEFAULT '0',
  `islock` smallint(1) DEFAULT '0',
  PRIMARY KEY (`adminid`),
  KEY `adminname` (`adminname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_admin_log
-- ----------------------------
DROP TABLE IF EXISTS `cms_admin_log`;
CREATE TABLE `cms_admin_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `msg` varchar(255) DEFAULT '',
  `ip` varchar(50) DEFAULT '',
  `createdate` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_admin_login_log
-- ----------------------------
DROP TABLE IF EXISTS `cms_admin_login_log`;
CREATE TABLE `cms_admin_login_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `loginname` varchar(50) DEFAULT '',
  `loginip` varchar(50) DEFAULT '',
  `logindate` bigint(10) DEFAULT '0',
  `loginmsg` varchar(255) DEFAULT '',
  `loginstate` smallint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_admin_menu
-- ----------------------------
DROP TABLE IF EXISTS `cms_admin_menu`;
CREATE TABLE `cms_admin_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `cname` varchar(50) DEFAULT '',
  `aname` varchar(50) DEFAULT '',
  `dname` varchar(255) DEFAULT '',
  `icon` varchar(50) DEFAULT '',
  `followid` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` smallint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_admin_part
-- ----------------------------
DROP TABLE IF EXISTS `cms_admin_part`;
CREATE TABLE `cms_admin_part` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `page_list` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_alias
-- ----------------------------
DROP TABLE IF EXISTS `cms_alias`;
CREATE TABLE `cms_alias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `alias` varchar(50) DEFAULT '',
  `app` varchar(50) DEFAULT '',
  `sid` int(10) DEFAULT '0',
  `types` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `alias` (`alias`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_class
-- ----------------------------
DROP TABLE IF EXISTS `cms_class`;
CREATE TABLE `cms_class` (
  `cateid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `followid` int(10) DEFAULT '0',
  `cate_name` varchar(50) DEFAULT '' COMMENT '栏目名称',
  `cate_type` smallint(2) DEFAULT '0' COMMENT '栏目类型',
  `cate_url` varchar(255) DEFAULT '' COMMENT '别名、网址',
  `cate_filter` varchar(255) DEFAULT '',
  `cate_pay` smallint(1) DEFAULT '0' COMMENT '收费方式（0：不收费，2：内容收费，3：下载收费，4：视频收费）',
  `cate_page` int(10) DEFAULT '20' COMMENT '分页数量',
  `cate_order` int(10) DEFAULT '0' COMMENT '排序',
  `cate_title` varchar(255) DEFAULT '',
  `cate_key` varchar(255) DEFAULT '',
  `cate_desc` varchar(255) DEFAULT '',
  `cate_list` varchar(255) DEFAULT '' COMMENT '自定义：列表模板',
  `cate_show` varchar(255) DEFAULT '' COMMENT '自定义：内容页模板',
  `cate_pic` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `cate_en` varchar(255) DEFAULT '' COMMENT '栏目英文',
  `ispost` smallint(1) DEFAULT '0' COMMENT '是否允许投稿',
  `isgroup` smallint(1) DEFAULT '0' COMMENT '是否开启组图功能',
  `ismenu` smallint(1) DEFAULT '0' COMMENT '是否导航显示',
  `isnew` smallint(1) DEFAULT '0' COMMENT '是否新窗口',
  PRIMARY KEY (`cateid`),
  KEY `order` (`cate_order`,`cateid`),
  KEY `where` (`followid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_comment
-- ----------------------------
DROP TABLE IF EXISTS `cms_comment`;
CREATE TABLE `cms_comment` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0' COMMENT '内容ID',
  `parentid` int(10) DEFAULT '0',
  `userid` int(10) unsigned DEFAULT '0',
  `postip` varchar(255) DEFAULT '',
  `postdate` bigint(10) DEFAULT '0',
  `postcity` varchar(20) DEFAULT '',
  `content` text,
  `sonnum` int(10) DEFAULT '0' COMMENT '子评论数量',
  `likenum` int(10) DEFAULT '0' COMMENT '点赞数量',
  `state` smallint(1) DEFAULT '0' COMMENT '状态：（1：显示，0：不显示）',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_config
-- ----------------------------
DROP TABLE IF EXISTS `cms_config`;
CREATE TABLE `cms_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gid` int(10) DEFAULT '0',
  `ckey` varchar(50) DEFAULT '',
  `ctitle` varchar(50) DEFAULT '',
  `cvalue` text,
  `ordnum` int(10) DEFAULT '0',
  `ctype` int(10) DEFAULT '0',
  `dvalue` text,
  `dtext` text,
  `rtype` smallint(1) DEFAULT '0',
  `utype` smallint(1) DEFAULT '0',
  `islock` smallint(1) DEFAULT '0',
  `issys` smallint(1) DEFAULT '0',
  `ishide` smallint(1) DEFAULT '0',
  `field_table` varchar(255) DEFAULT '',
  `field_join` varchar(510) DEFAULT '',
  `field_where` varchar(510) DEFAULT '',
  `field_order` varchar(510) DEFAULT '',
  `field_value` varchar(255) DEFAULT '',
  `field_label` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `ckey` (`ckey`),
  KEY `gid` (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_config_group
-- ----------------------------
DROP TABLE IF EXISTS `cms_config_group`;
CREATE TABLE `cms_config_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gname` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `gkey` varchar(50) DEFAULT '',
  `islock` smallint(1) DEFAULT '0',
  `types` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_data
-- ----------------------------
DROP TABLE IF EXISTS `cms_data`;
CREATE TABLE `cms_data` (
  `dataid` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `cid` bigint(10) unsigned DEFAULT '0' COMMENT '内容ID',
  `tags` varchar(255) DEFAULT '',
  `tagslist` varchar(510) DEFAULT '',
  `show_title` varchar(510) DEFAULT '',
  `show_key` varchar(510) DEFAULT '',
  `show_desc` varchar(510) DEFAULT '',
  `show_theme` varchar(255) DEFAULT '',
  `piclist` text,
  `intro` varchar(510) DEFAULT '',
  `content` mediumtext,
  `videourl` varchar(510) DEFAULT '',
  `downurl` varchar(510) DEFAULT '',
  `demourl` varchar(510) DEFAULT '',
  `video_type` smallint(1) DEFAULT '0',
  `video_data` text,
  `down_type` smallint(1) DEFAULT '0',
  `panurl` varchar(510) DEFAULT '',
  `panpass` varchar(20) DEFAULT '',
  PRIMARY KEY (`dataid`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_field
-- ----------------------------
DROP TABLE IF EXISTS `cms_field`;
CREATE TABLE `cms_field` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` int(10) DEFAULT '0',
  `field_title` varchar(50) DEFAULT '',
  `field_key` varchar(50) DEFAULT '',
  `field_type` int(5) DEFAULT '0',
  `field_length` int(10) DEFAULT '0',
  `field_upload_type` int(10) DEFAULT '0',
  `field_default` varchar(255) DEFAULT '',
  `field_list` text,
  `field_sql` varchar(255) DEFAULT '',
  `field_tips` varchar(255) DEFAULT '',
  `field_rule` int(10) DEFAULT '0',
  `field_radio` int(10) DEFAULT '0',
  `field_editor` int(10) DEFAULT '0',
  `field_group` int(10) DEFAULT '0',
  `field_filter` int(10) DEFAULT '0',
  `field_table` varchar(50) DEFAULT '',
  `field_join` varchar(255) DEFAULT '',
  `field_where` varchar(255) DEFAULT '',
  `field_order` varchar(255) DEFAULT '',
  `field_value` varchar(50) DEFAULT '',
  `field_label` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `isshow` smallint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_file
-- ----------------------------
DROP TABLE IF EXISTS `cms_file`;
CREATE TABLE `cms_file` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '1：图片，2：音频，3：视频，4：其他文件',
  `gid` int(10) DEFAULT '0',
  `file_url` varchar(255) DEFAULT '',
  `file_name` varchar(255) DEFAULT '' COMMENT '文件名',
  `file_ext` varchar(50) DEFAULT '' COMMENT '后缀',
  `file_size` int(10) DEFAULT '0',
  `file_type` int(10) DEFAULT '0' COMMENT '1：图片，2：视频，3：其他',
  `file_local` varchar(50) DEFAULT '',
  `file_update` bigint(10) DEFAULT '0' COMMENT '上传的日期',
  `file_ip` varchar(50) DEFAULT '' COMMENT '上传者IP',
  `file_adminid` int(10) DEFAULT '0',
  `userid` int(10) unsigned DEFAULT '0',
  `file_tmp` varchar(510) DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type` (`file_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_file_group
-- ----------------------------
DROP TABLE IF EXISTS `cms_file_group`;
CREATE TABLE `cms_file_group` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gname` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` smallint(1) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_filter
-- ----------------------------
DROP TABLE IF EXISTS `cms_filter`;
CREATE TABLE `cms_filter` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` smallint(1) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_filter_list
-- ----------------------------
DROP TABLE IF EXISTS `cms_filter_list`;
CREATE TABLE `cms_filter_list` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) DEFAULT '0',
  `name` varchar(50) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_link
-- ----------------------------
DROP TABLE IF EXISTS `cms_link`;
CREATE TABLE `cms_link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `isshow` smallint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_order
-- ----------------------------
DROP TABLE IF EXISTS `cms_order`;
CREATE TABLE `cms_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_no` varchar(50) DEFAULT '' COMMENT '订单编号',
  `order_total` decimal(10,2) DEFAULT '0.00' COMMENT '订单应付总金额',
  `goods_total` decimal(10,2) DEFAULT '0.00' COMMENT '商品总金额',
  `cost_total` decimal(10,2) DEFAULT '0.00' COMMENT '代金券金额',
  `cost_id` int(10) DEFAULT '0' COMMENT '代金券ID',
  `order_money` decimal(10,2) DEFAULT '0.00' COMMENT '抵扣的佣金',
  `goods_money` decimal(10,2) DEFAULT '0.00' COMMENT '商品佣金（总）',
  `ispay` smallint(1) DEFAULT '0' COMMENT '是否付款',
  `paydate` bigint(10) DEFAULT '0' COMMENT '付款日期',
  `payway` varchar(50) DEFAULT '' COMMENT '付款方式：（支付后直接返回）',
  `trade_no` varchar(510) DEFAULT '' COMMENT '订单交易号',
  `order_type` smallint(1) DEFAULT '0' COMMENT '订单类型（0：授权，1：内容，2：购买会员）',
  `goods_id` int(10) DEFAULT '0' COMMENT '内容ID或会员组ID',
  `isdown` smallint(1) DEFAULT '0' COMMENT '是否为下载(1：是，0：否)',
  `userid` int(10) unsigned DEFAULT '0',
  `userkey` varchar(255) DEFAULT '' COMMENT '游客key',
  `postcity` varchar(255) DEFAULT '',
  `postip` varchar(255) DEFAULT '',
  `createdate` bigint(10) DEFAULT '0',
  `comefrom` smallint(1) DEFAULT '0' COMMENT '订单来源（1：PC，2：手机，3：微信）',
  `remark` varchar(255) DEFAULT '',
  `isdel` smallint(1) DEFAULT '0',
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_order_list
-- ----------------------------
DROP TABLE IF EXISTS `cms_order_list`;
CREATE TABLE `cms_order_list` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `orderid` int(10) unsigned DEFAULT '0' COMMENT '订单编号',
  `goods_id` int(10) unsigned DEFAULT '0' COMMENT '商品ID',
  `goods_skuid` int(10) DEFAULT '0' COMMENT '规格ID',
  `goods_name` varchar(510) CHARACTER SET utf8 DEFAULT '' COMMENT '商品名称',
  `goods_sku` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '商品SKU',
  `goods_pic` varchar(255) DEFAULT '',
  `goods_num` int(10) DEFAULT '0' COMMENT '购买数量',
  `goods_price` decimal(10,2) DEFAULT '0.00',
  `goods_version` smallint(1) DEFAULT '0',
  `userid` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_page
-- ----------------------------
DROP TABLE IF EXISTS `cms_page`;
CREATE TABLE `cms_page` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT NULL,
  `piclist` text,
  `content` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_plug
-- ----------------------------
DROP TABLE IF EXISTS `cms_plug`;
CREATE TABLE `cms_plug` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT '' COMMENT '名称',
  `root` varchar(100) DEFAULT '' COMMENT '路径',
  `icon` varchar(255) DEFAULT '',
  `intro` varchar(510) DEFAULT '',
  `type` varchar(50) DEFAULT '' COMMENT '插件类型',
  `hook` smallint(1) DEFAULT '0' COMMENT '是否有hook',
  `version` varchar(50) DEFAULT '' COMMENT '当前版本',
  `author` varchar(255) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `config` text COMMENT '配置数据',
  `admin` smallint(1) unsigned DEFAULT '0',
  `state` smallint(1) DEFAULT '0' COMMENT '状态（1：启用，0：禁用）',
  `menu` smallint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_show
-- ----------------------------
DROP TABLE IF EXISTS `cms_show`;
CREATE TABLE `cms_show` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `classid` int(10) DEFAULT '0',
  `title` varchar(255) DEFAULT '',
  `pic` varchar(255) DEFAULT '',
  `ispic` smallint(1) DEFAULT '0',
  `price` decimal(10,2) DEFAULT '0.00',
  `money` decimal(10,2) DEFAULT '0.00' COMMENT '佣金',
  `vsales` int(10) unsigned DEFAULT '0',
  `tsales` int(10) unsigned DEFAULT '0',
  `alias` varchar(50) DEFAULT '',
  `isnice` smallint(1) DEFAULT '0',
  `isshow` smallint(2) DEFAULT '0',
  `isauto` smallint(1) DEFAULT '0',
  `isallow` smallint(1) DEFAULT '0' COMMENT '是否允许评论',
  `ordnum` int(10) DEFAULT '0',
  `hits` int(10) unsigned DEFAULT '0',
  `love` int(10) unsigned DEFAULT '0',
  `filter` varchar(255) DEFAULT '',
  `createdate` bigint(10) DEFAULT '0',
  `lastupdate` bigint(10) DEFAULT '0',
  `adminid` int(10) DEFAULT '0',
  `userid` int(10) unsigned DEFAULT '0',
  `reason` varchar(255) DEFAULT '' COMMENT '拒绝的原因',
  `reward` smallint(1) DEFAULT '0' COMMENT '是否已经发放奖励',
  `payway` smallint(1) DEFAULT '1',
  `discount` varchar(510) DEFAULT '[]',
  `vipgroup` varchar(255) DEFAULT '',
  `sideid` varchar(255) DEFAULT '',
  `isurl` smallint(1) DEFAULT '0',
  `url` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `where1` (`isshow`,`classid`),
  KEY `where2` (`isshow`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_sms
-- ----------------------------
DROP TABLE IF EXISTS `cms_sms`;
CREATE TABLE `cms_sms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mobile` varchar(20) DEFAULT '',
  `code` varchar(20) DEFAULT '' COMMENT '短信验证码',
  `type` varchar(20) DEFAULT '' COMMENT '型类：reg,login,getpass等',
  `enddate` bigint(10) DEFAULT '0' COMMENT '失效时间（可选）',
  `state` smallint(1) DEFAULT '0' COMMENT '是否已经使用（1：是，0：否）',
  `postip` varchar(255) DEFAULT '',
  `postdate` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_tags
-- ----------------------------
DROP TABLE IF EXISTS `cms_tags`;
CREATE TABLE `cms_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `isshow` smallint(1) DEFAULT '0',
  `seo_title` varchar(255) DEFAULT '',
  `seo_key` varchar(255) DEFAULT '',
  `seo_desc` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `id` (`id`),
  KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_token
-- ----------------------------
DROP TABLE IF EXISTS `cms_token`;
CREATE TABLE `cms_token` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `token` text,
  `type` varchar(50) DEFAULT '',
  `createdate` bigint(10) DEFAULT '0',
  `overdate` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_upload
-- ----------------------------
DROP TABLE IF EXISTS `cms_upload`;
CREATE TABLE `cms_upload` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT '',
  `name` varchar(32) DEFAULT '',
  `val` varchar(510) DEFAULT '',
  `part` text,
  `rand` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_user
-- ----------------------------
DROP TABLE IF EXISTS `cms_user`;
CREATE TABLE `cms_user` (
  `atid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `umobile` varchar(11) DEFAULT '',
  `upass` varchar(32) DEFAULT '',
  `uid` int(10) DEFAULT '0' COMMENT '会员组ID',
  `pid` int(10) DEFAULT '0' COMMENT '父ID',
  `uname` varchar(50) DEFAULT '' COMMENT '昵称（必须唯一）',
  `uface` varchar(255) DEFAULT '' COMMENT '头像',
  `uintro` varchar(510) DEFAULT '',
  `amount` decimal(10,2) DEFAULT '0.00' COMMENT '累计消费金额',
  `invoice` decimal(10,2) DEFAULT '0.00' COMMENT '已开票金额',
  `umoney` decimal(10,2) DEFAULT '0.00' COMMENT '佣金',
  `fmoney` decimal(10,2) DEFAULT '0.00' COMMENT '冻结的佣金',
  `tmoney` decimal(10,2) DEFAULT '0.00' COMMENT '总计提现的佣金',
  `percent` int(3) DEFAULT '0' COMMENT '投稿收入百分比',
  `regdate` bigint(10) DEFAULT '0' COMMENT '注册的日期',
  `regip` varchar(255) DEFAULT '' COMMENT '注册的IP',
  `islock` smallint(1) DEFAULT '0',
  `isauth` smallint(1) DEFAULT '1',
  `iscash` smallint(1) DEFAULT '1',
  `logintimes` int(10) DEFAULT '0' COMMENT '登录次数',
  `lastloginip` varchar(255) DEFAULT '' COMMENT '最后登录IP',
  `lastlogindate` bigint(10) DEFAULT '0' COMMENT '最后登录日期',
  `enddate` bigint(10) unsigned DEFAULT '0',
  PRIMARY KEY (`atid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_user_auth
-- ----------------------------
DROP TABLE IF EXISTS `cms_user_auth`;
CREATE TABLE `cms_user_auth` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `type` smallint(1) DEFAULT '0' COMMENT '认证类型（1：个人，2：公司）',
  `name` varchar(20) DEFAULT '',
  `idcard` varchar(30) DEFAULT '' COMMENT '身份证号码',
  `postdate` bigint(10) DEFAULT '0',
  `state` smallint(1) DEFAULT '1' COMMENT '审核结果（1：待审，2：成功，3：失败）',
  `msg` varchar(255) DEFAULT '',
  `times` int(10) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_user_bill
-- ----------------------------
DROP TABLE IF EXISTS `cms_user_bill`;
CREATE TABLE `cms_user_bill` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `money` decimal(10,2) DEFAULT '0.00' COMMENT '发票金额',
  `company` varchar(510) DEFAULT '',
  `idnumber` varchar(255) DEFAULT '' COMMENT '纳税人识别号',
  `blank` varchar(510) DEFAULT '' COMMENT '开户银行',
  `blanknum` varchar(255) DEFAULT '',
  `address` varchar(510) DEFAULT '' COMMENT '公司地址',
  `tel` varchar(20) DEFAULT '',
  `postdate` bigint(10) DEFAULT '0',
  `downurl` varchar(255) DEFAULT '' COMMENT '发票下载地址',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_user_buy
-- ----------------------------
DROP TABLE IF EXISTS `cms_user_buy`;
CREATE TABLE `cms_user_buy` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `userkey` varchar(255) DEFAULT '',
  `cid` int(10) DEFAULT '0',
  `cprice` decimal(10,2) DEFAULT '0.00',
  `postdate` bigint(10) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_user_cash
-- ----------------------------
DROP TABLE IF EXISTS `cms_user_cash`;
CREATE TABLE `cms_user_cash` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `orderid` varchar(255) DEFAULT '',
  `userid` int(10) unsigned DEFAULT '0',
  `money` decimal(10,2) DEFAULT '0.00',
  `name` varchar(20) DEFAULT '' COMMENT '支付宝姓名',
  `alipay` varchar(255) DEFAULT '' COMMENT '支付宝账号',
  `postdate` bigint(10) DEFAULT '0',
  `state` smallint(1) DEFAULT '0' COMMENT '状态（1：待处理，2：成功，3：失败）',
  `remark` varchar(255) DEFAULT '' COMMENT '拒绝的原因',
  `type` smallint(1) DEFAULT '0' COMMENT '提现方式：（1：手工提现，2：支付宝接口）',
  `trade_no` varchar(255) DEFAULT '' COMMENT '付款交易号',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_user_down
-- ----------------------------
DROP TABLE IF EXISTS `cms_user_down`;
CREATE TABLE `cms_user_down` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `userkey` varchar(255) DEFAULT '',
  `cid` int(10) DEFAULT '0',
  `num` int(10) DEFAULT '1' COMMENT '下载次数',
  `postdate` bigint(10) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_user_group
-- ----------------------------
DROP TABLE IF EXISTS `cms_user_group`;
CREATE TABLE `cms_user_group` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `isupgrade` smallint(1) DEFAULT '0' COMMENT '是否允许自动升级',
  `upvalue` int(10) DEFAULT '0' COMMENT '自动升级消费金额',
  `freenum` int(10) DEFAULT '0' COMMENT '每天免费下载文件个数',
  `price` decimal(10,2) DEFAULT '0.00' COMMENT '价格',
  `type` smallint(1) DEFAULT '0' COMMENT '有效期类型（1：天，2：月，3：年，4：永久有效）',
  `num` int(10) DEFAULT '0' COMMENT '有效期',
  `upload` smallint(1) DEFAULT '0' COMMENT '是否允许上传文件',
  `post` smallint(1) DEFAULT '0' COMMENT '是否允许投稿',
  `ordnum` int(10) DEFAULT '0' COMMENT '是否允许投稿',
  `discount` decimal(10,2) DEFAULT '100.00',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_user_login
-- ----------------------------
DROP TABLE IF EXISTS `cms_user_login`;
CREATE TABLE `cms_user_login` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `type` varchar(50) DEFAULT '',
  `openid` varchar(255) DEFAULT '',
  `unionid` varchar(255) DEFAULT '',
  `binddate` bigint(10) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_user_love
-- ----------------------------
DROP TABLE IF EXISTS `cms_user_love`;
CREATE TABLE `cms_user_love` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `cid` int(10) DEFAULT '0',
  `lovedate` bigint(10) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for cms_user_money
-- ----------------------------
DROP TABLE IF EXISTS `cms_user_money`;
CREATE TABLE `cms_user_money` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned DEFAULT '0',
  `money` decimal(10,2) DEFAULT '0.00',
  `oldmoney` decimal(10,2) DEFAULT '0.00',
  `newmoney` decimal(10,2) DEFAULT '0.00',
  `type` smallint(1) DEFAULT '0' COMMENT '1:增加，2：减少',
  `title` varchar(255) DEFAULT '',
  `createdate` bigint(10) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `cms_ad_group` VALUES ('1', 'PC站Banner', '0', 'pc');
INSERT INTO `cms_ad_group` VALUES ('2', '手机站Banner', '0', 'mobile');
INSERT INTO `cms_admin_menu` VALUES ('1', '设置', '', '', '', 'ui-icon-setting', '0', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('2', '会员', '', '', '', 'ui-icon-user', '0', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('3', '内容', '', '', '', 'ui-icon-layout', '0', '5', '1');
INSERT INTO `cms_admin_menu` VALUES ('4', '订单', '', '', '', 'ui-icon-filter', '0', '7', '1');
INSERT INTO `cms_admin_menu` VALUES ('5', '报表', '', '', '', 'ui-icon-barchart', '0', '9', '1');
INSERT INTO `cms_admin_menu` VALUES ('6', '应用', '', '', '', 'ui-icon-appstore', '0', '11', '1');
INSERT INTO `cms_admin_menu` VALUES ('7', '扩展', '', '', '', 'ui-icon-api', '0', '13', '1');
INSERT INTO `cms_admin_menu` VALUES ('8', '系统', '', '', '', 'ui-icon-windows', '0', '15', '1');
INSERT INTO `cms_admin_menu` VALUES ('9', '网站设置', 'config', 'index', '', '', '1', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('10', '部门管理', 'adminpart', 'index', '', '', '1', '5', '1');
INSERT INTO `cms_admin_menu` VALUES ('11', '后台用户', 'admin', 'index', '', '', '1', '7', '1');
INSERT INTO `cms_admin_menu` VALUES ('12', '会员管理', 'user', 'index', '', '', '2', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('13', '分组管理', 'usergroup', 'index', '', '', '2', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('14', '佣金管理', 'usermoney', 'index', '', '', '2', '5', '1');
INSERT INTO `cms_admin_menu` VALUES ('15', '提现管理', 'usercash', 'index', '', '', '2', '7', '1');
INSERT INTO `cms_admin_menu` VALUES ('16', '发票管理', 'userbill', 'index', '', '', '2', '9', '1');
INSERT INTO `cms_admin_menu` VALUES ('17', '认证管理', 'userauth', 'index', '', '', '2', '11', '1');
INSERT INTO `cms_admin_menu` VALUES ('18', '购买记录', 'userbuy', 'index', '', '', '2', '13', '1');
INSERT INTO `cms_admin_menu` VALUES ('19', '下载记录', 'userdown', 'index', '', '', '2', '15', '1');
INSERT INTO `cms_admin_menu` VALUES ('20', '栏目管理', 'cate', 'index', '', '', '3', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('21', '筛选方案', 'filter', 'index', '', '', '3', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('22', '内容管理', 'content', 'index', '', '', '3', '5', '1');
INSERT INTO `cms_admin_menu` VALUES ('23', '回收站', 'contentrecycle', 'index', '', '', '3', '7', '1');
INSERT INTO `cms_admin_menu` VALUES ('24', '订单管理', 'order', 'index', '', '', '4', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('25', '回收站', 'orderrecycle', 'index', '', '', '4', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('26', '收入统计', 'count', 'index', '', '', '5', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('27', '订单统计', 'countorder', 'index', '', '', '5', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('28', '佣金统计', 'countpay', 'index', '', '', '5', '5', '1');
INSERT INTO `cms_admin_menu` VALUES ('29', '模板管理', 'theme', 'index', '', '', '6', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('30', '插件管理', 'plug', 'index', '', '', '6', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('31', '评论管理', 'comment', 'index', '', '', '7', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('32', '友情链接', 'link', 'index', '', '', '7', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('33', '轮播图片', 'ad', 'index', '', '', '7', '5', '1');
INSERT INTO `cms_admin_menu` VALUES ('34', '标签管理', 'tags', 'index', '', '', '7', '7', '1');
INSERT INTO `cms_admin_menu` VALUES ('35', '字段管理', 'field', 'index', '', '', '7', '9', '1');
INSERT INTO `cms_admin_menu` VALUES ('36', '设置分组', 'configgroup', 'index', '', '', '8', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('37', '后台菜单', 'adminmenu', 'index', '', '', '8', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('38', '管理日志', 'log', 'index', '', '', '8', '5', '1');
INSERT INTO `cms_admin_menu` VALUES ('39', '错误日志', 'logerror', 'index', '', '', '8', '7', '1');
INSERT INTO `cms_admin_menu` VALUES ('40', '缓存管理', 'cache', 'index', '', '', '8', '9', '1');
INSERT INTO `cms_admin_menu` VALUES ('41', '区块管理', 'block', 'index', '', '', '3', '9', '1');
INSERT INTO `cms_config` VALUES ('1', '1', 'web_line', '网站设置', '', '1', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('2', '1', 'web_open', '网站开关', '1', '3', '6', '开启|1,关闭|0', '关闭后前台无法访问，后台不影响使用', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('3', '1', 'web_close', '关闭原因', '临时维护，请稍候访问。', '5', '5', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('4', '1', 'web_name', '网站名称', '网站名称', '7', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('5', '1', 'web_logo', '网站Logo', '/upfile/logo.png', '9', '4', '', '', '1', '1', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('6', '1', 'web_count', '统计代码', '', '11', '10', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('7', '1', 'domain_line', '域名设置', '', '13', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('8', '1', 'domain_http', 'Http类型', 'http://', '15', '6', 'Http://|http://,Https://|https://', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('9', '1', 'domain_main', '主域名', '', '17', '1', '', '例：www.baidu.com，可以为空', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('10', '1', 'domain_other', '副域名', '', '19', '5', '', '一行一条，格式：www.baidu.com 或 baidu.com，副域名会自动跳转到主域名', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('11', '1', 'beian_line', '备案设置', '', '21', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('12', '1', 'icp_num', 'ICP备案号', '', '23', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('13', '1', 'icp_url', 'ICP备案号链接', 'https://beian.miit.gov.cn', '24', '1', '', '一般情况下无需修改', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('14', '1', 'ga_num', '公安备案号', '', '25', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('15', '1', 'ga_url', '公安备案链接', '', '27', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('16', '1', 'ct_line', '联系方式', '', '29', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('17', '1', 'ct_tel', '客服电话', '', '31', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('18', '1', 'ct_qq', '客服QQ', '', '33', '5', '', '格式：在线客服|100001，一行一条', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('19', '1', 'ct_weixin', '微信二维码', '', '35', '4', '', '上传微信二维码，方便客户加好友', '1', '1', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('20', '2', 'url_mode_line', 'Url设置', '', '1', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('21', '2', 'url_mode', 'Url模式', '1', '3', '6', '调试模式（例: /?m=home）|1,Path_Info模式（例: /index.php/news.html）|2,伪静态模式（例: /news.html）|3', '建议伪静态模式（需要上传或配置伪静态规则）', '2', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('22', '2', 'url_mid', 'Url间隔符', '/', '5', '8', '/|/,_|_', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('23', '2', 'url_ext', 'Url后缀', '.html', '7', '8', '无后缀|,/|/,.html|.html', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('24', '2', 'seo_line', 'SEO设置', '', '9', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('25', '2', 'web_title', '自定义标题', '', '11', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('26', '2', 'web_key', '关键字', '', '13', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('27', '2', 'web_desc', '描述', '', '15', '5', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('28', '2', 'seo_mid', '标题间隔符', ' - ', '17', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('29', '3', 'upload_way', '存储方式', 'local', '1', '11', '', '', '1', '0', '1', '1', '0', 'cms_plug', '', 'state=1 and type=&#039;upload&#039;', 'id desc', 'root', 'name');
INSERT INTO `cms_config` VALUES ('30', '3', 'upload_line', '上传设置', '', '3', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('31', '3', 'upload_max', '最大上传', '10', '5', '1', '', '单位：M', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('32', '3', 'upload_slice', '分片大小', '2', '7', '1', '', '单位：M，为0时不分片', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('33', '3', 'upload_file_folder', '存放路径', '2', '9', '8', '年/文件名|1,年/月/文件名|2,年/月/日/文件名|3', '', '2', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('34', '3', 'thumb_line', '图片压缩', '', '11', '0', '', '云存储分片时无效', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('35', '3', 'thumb_open', '压缩开关', '0', '13', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('36', '3', 'thumb_min', '压缩宽度', '800', '15', '1', '', '图片会被压缩成这个宽度', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('37', '3', 'thumb_piclist', '组图压缩', '0', '17', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('38', '3', 'water_line', '图片水印', '', '19', '0', '', '云存储分片时无效', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('39', '3', 'water_open', '水印开关', '0', '21', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('40', '3', 'water_width', '最小宽度', '400', '23', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('41', '3', 'water_height', '最小高度', '300', '25', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('42', '3', 'water_opacity', '透明度', '60', '27', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('43', '3', 'water_position', '水印位置', '5', '29', '8', '随机显示|0,顶部居左|1,顶部居中|2,顶部居右|3,中部居左|4,中部居中|5,中部居右|6,底部居左|7,底部居中|8,底部居右|9', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('44', '3', 'water_logo', '水印Logo', '/upfile/logo.png', '31', '4', '', '', '1', '1', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('45', '3', 'water_piclist', '组图水印', '0', '33', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('46', '4', 'mobile_open', '开关', '1', '1', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('47', '4', 'mobile_http', 'Http类型', 'http://', '3', '6', 'Http://|http://,Https://|https://', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('48', '4', 'mobile_domain', '绑定域名', '', '5', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('49', '4', 'mobile_auto', '自动识别', '1', '7', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('50', '4', 'mobile_logo', '手机站Logo', '/upfile/logo-m.png', '9', '4', '', '', '1', '1', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('51', '5', 'user_open', '开放注册', '1', '1', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('52', '5', 'user_reg_type', '注册审核', '1', '3', '6', '直接通过|1,短信验证|2,管理员审核|3', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('53', '5', 'user_login_sms', '短信登录', '0', '5', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('54', '5', 'login_state', '快捷登录', '1', '7', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('55', '5', 'user_reg_group', '加入用户组', '1', '9', '11', '', '', '1', '0', '1', '1', '0', 'cms_user_group', '', '', 'ordnum,aid', 'aid', 'title');
INSERT INTO `cms_config` VALUES ('56', '5', 'user_reg_auth', '注册验证码', '1', '11', '6', '开启|1,关闭|2', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('57', '5', 'user_login_auth', '登录验证码', '1', '13', '6', '开启|1,关闭|2', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('58', '5', 'user_getpass_auth', '忘记密码验证码', '1', '15', '6', '开启|1,关闭|2', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('59', '5', 'user_visitor', '游客购买', '0', '17', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('60', '5', 'user_bill_min', '开票限额', '500', '19', '1', '', '必须达到此金额才能开票', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('61', '5', 'user_cash_min', '提现限额', '100', '21', '1', '', '必须达到此金额才能提现', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('62', '5', 'user_post', '投稿开关', '1', '23', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('63', '5', 'user_post_money', '投稿奖励', '10', '25', '1', '', '每个投稿给予的最低奖励金额', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('64', '5', 'user_percent', '投稿分成', '50', '27', '1', '', '请输入0-100之间的数字（会员注册后默认分成比例）', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('65', '5', 'user_agree', '注册协议', '<p style=\"text-indent: 2em;\">\r\n    <strong>一、总则</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （一）平台的所有权和运营权归_______________公司所有。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （二）用户在注册之前，应当仔细阅读本协议，并同意遵守本协议后方可成为注册用户。一旦注册成功，则用户与平台之间自动形成协议关系，用户应当受本协议的约束。用户必须完全同意所有服务条款并完成注册程序，才能成为平台的正式用户。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （三）本协议可由平台随时更新，用户应当及时关注并同意本站不承担通知义务。本站的通知、公告、声明或其它类似内容是本协议的一部分。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>二、服务内容</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （一）平台的具体内容由本站根据实际情况提供。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （二）本站仅提供相关的网络服务，除此之外与相关网络服务有关的设备（如个人电脑、手机、及其他与接入互联网或移动网有关的装置）及所需的费用（如为接入互联网而支付的电话费及上网费、为使用移动网而支付的手机费）均应由用户自行负担。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （三）如果用户提供的资料包含有不正确的信息，本平台保留结束用户使用网络服务资格的权利。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>三、用户账号</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （一）经本站注册系统完成注册程序并通过身份认证的用户即成为正式用户，可以获得本站规定用户所应享有的一切权限；未经身份认证仅享有本站规定的部分会员权限。平台有权对会员的权限设计进行变更。如果用户提供的注册资料不合法、不真实、不准确、不详尽的，用户需承担因此引起的相应责任及后果，并且平台保留终止用户使用平台服务的权利。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （二）用户只能按照注册要求使用真实手机号码注册。用户有义务保证密码和账号的安全，用户利用该密码和账号所进行的一切活动引起的任何损失或损害，由用户自行承担全部责任，本站不承担任何责任。如用户发现账号遭到未授权的使用或发生其他任何安全问题，应立即修改账号密码并妥善保管，如有必要，请通知本站。因黑客行为或用户的保管疏忽导致账号非法使用，本站不承担任何责任。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （三）用户若发现任何非法使用用户账号或存在安全漏洞的情况，请立即通告平台。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>四、使用规则</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （一）遵守中华人民共和国相关法律法规，包括但不限于《中华人民共和国计算机信息系统安全保护条例》、《计算机软件保护条例》、《最高人民法院关于审理涉及计算机网络著作权纠纷案件适用法律若干问题的解释（法释[]1号）》、《全国人大常委会关于维护互联网安全的决定》、《互联网电子公告服务管理规定》、《互联网新闻信息服务管理规定》、《互联网著作权行政保护办法》和《信息网络传播权保护条例》等有关计算机互联网规定和知识产权的法律和法规、实施办法。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （二）用户对其自行发表、上传或传送的内容负全部责任，所有用户不得在本站任何页面发布、转载、传送含有下列内容之一的信息，否则本站有权自行处理并不通知用户：\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    1、违反宪法确定的基本原则的；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    2、危害国家安全，泄漏国家机密，颠覆国家政权，破坏国家统一的；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    3、损害国家荣誉和利益的；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    4、煽动民族仇恨、民族歧视，破坏民族团结的；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    5、破坏国家宗教政策，宣扬邪教和封建迷信的；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    6、散布谣言，扰乱社会秩序，破坏社会稳定的；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    7、散布淫秽、色情、赌博、暴力、恐怖或者教唆犯罪的；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    8、侮辱或者诽谤他人，侵害他人合法权益的；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    9、煽动非法集会、结社、游行、示威、聚众扰乱社会秩序的；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    10、以非法民间组织名义活动的；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    11、含有法律、行政法规禁止的其他内容的；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    12、不得传输或发表：煽动抗拒、破坏宪法和法律、行政法规实施的言论，煽动颠覆国家政权，推翻社会主义制度的言论，煽动分裂国家、破坏国家统一的的言论，煽动民族仇恨、民族歧视、破坏民族团结的言论。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （三）用户承诺对其发表或者上传于本站的所有信息（即属于《中华人民共和国著作权法》规定的作品，包括但不限于地图数据、文字、图片、音乐、电影、表演和录音录像制品和电脑程序等）均享有完整的知识产权，或者已经得到相关权利人的合法授权；如用户违反本条规定造成本站被第三人索赔的，用户应全额补偿本站一切费用（包括但不限于各种赔偿费、诉讼代理费及为此支出的其它合理费用）。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （四）当第三方认为用户发表或者上传于本站的信息侵犯其权利，并根据《信息网络传播权保护条例》或者相关法律规定向本站发送权利通知书时，用户同意本站可以自行判断决定删除涉嫌侵权信息，除非用户提交书面证据材料排除侵权的可能性，本站将不会自动恢复上述删除的信息。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （五）平台保有删除站内各类不符合法律政策或不真实的信息内容而无须通知用户的权利。若用户未遵守以上规定的，平台有权作出独立判断并采取暂停或关闭用户账号等措施。用户须对自己在网上的言论和行为承担法律责任。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>五、隐私保护</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （一）尊重您个人信息的隐私是平台的一项基本制度，平台将会采取合理的措施保护您的个人信息。平台保证不对外公开或向第三方提供您的个人信息，但下列情况除外：\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    1、您的个人信息属于或者成为可公开获取的信息；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    2、由平台通过合法方式获知且无需对其履行保密义务的个人信息；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    3、通过可以合法披露此个人信息且无需对其履行保密义务的第三方获得的信息；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    4、事先获得您的明确授权；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    5、根据有关的法律法规的要求；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    6、按照相关政府主管部门或司法部门的要求；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    7、为维护社会公众的利益；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    8、为维护平台、其附属关联公司的合法权益。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （二）您理解并同意，平台可能会与第三方合作向您提供该服务，在此情况下，如该第三方同意承担与平台同等的保护您个人信息的责任，则平台将授权第三方通过________定义接口调用经过加密的您的个人信息，平台保证第三方不会直接获取您的个人信息。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （三）您理解并同意，在不透露您个人信息的前提下，平台有权对该服务的整个用户数据库进行分析并对用户数据库进行商业上的利用。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （四）在您使用该服务时，平台可能自动接收并记录您的地图应用端上的服务器数值，包括但不限于IP地址等数据、您和用户要求取用的网页记录及各种记录、该服务的操作状态以及使用习惯等一些明确且客观反映在平台服务器端的基本记录信息。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （五）________不允许任何人以任何手段收集、编辑、出售或者无偿传播您或其他用户的个人信息。一经发现您实施上述行为，________有权立即终止向您提供服务。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>六、免责声明</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （一）若平台已经明示其网络服务提供方式发生变更并提醒用户应当注意事项，用户未按要求操作所产生的一切后果由用户自行承担。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （二）用户明确同意其使用平台网络服务，以及因此对平台网络服务加以依赖所存在的全部责任和风险将完全由其自己承担；因其使用平台网络服务过程的行为，以及因此而产生的一切后果也由其自己承担，平台对用户不承担任何责任。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （三）平台不担保网络服务一定能满足用户的要求，也不担保网络服务不会中断，对网络服务的及时性、安全性、准确性也都不作担保。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （四）用户因使用平台网络服务而产生的任何间接的、附带的、特殊的、结果性的或惩戒性的损害（包括但不限于利润亏损、商誉、使用服务、数据的损害或其它无形损失），平台概不负责，均由用户自行承担。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （五）用户或用户的代理或关联人士违反本协议或相关法律，或因用户或用户的代理或关联人士（以参与者的身份行事）所做出的行为或疏忽而产生的任何损害，概由用户自行负责。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>七、拒绝提供担保</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    用户个人对网络服务的使用承担风险。平台对此不作任何类型的担保，不论是明确的或隐含的，但是不对商业性的隐含担保、特定目的和不违反规定的适当担保作限制。平台不担保服务一定能满足用户的要求，也不担保服务不会受中断，对服务的及时性，安全性，出错发生都不作担保。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>八、有限责任</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    平台对任何直接、间接、偶然、特殊及继起的损害不负责任，这些损害可能来自：不正当使用网络服务，在网上进行交易，非法使用网络服务或用户传送的信息有所变动。这些行为都有可能会导致本平台的形象受损，所以平台事先提出这种损害的可能性。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>九、对用户信息的存储和限制</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    平台不对用户所发布信息的删除或储存失败负责。平台有判定用户的行为是否符合平台服务条款的要求和精神的保留权利，如果用户违背了服务条款的规定，平台有中断对其提供网络服务的权利。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>十、用户管理</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （一）用户单独承担发布内容的责任。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （二）用户对服务的使用是根据所有适用于平台的国家法律、地方法律和国际法律标准的。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （三）用户必须遵循：\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    1、从中国境内向外传输技术性资料时必须符合中国有关法规；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    2、使用网络服务不作非法用途；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    3、不干扰或混乱网络服务；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    4、遵守所有使用网络服务的网络协议、规定、程序和惯例；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    5、招商引资活动符合法律规定及双方约定；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    6、用户须承诺不传输任何非法的、骚扰性的、中伤他人的、辱骂性的、恐性的、伤害性的、庸俗的，淫秽等信息资料；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    7、另外，用户也不能传输何教唆他人构成犯罪行为的资料；不能传输助长国内不利条件和涉及国家安全的资料；不能传输任何不符合当地法规、国家法律和国际法律的资料。未经许可而非法进入其它电脑系统是禁止的；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    8、若用户的行为不符合以上提到的服务条款，平台将作出独立判断立即取消用户服务账号。用户需对自己在网上的行为承担法律责任；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    9、用户若在平台上散布和传播反动、色情或其他违反国家法律的信息，平台的系统记录有可能作为用户违反法律的证据。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>十一、保障用户</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    同意保障和维护平台全体成员的利益，违反服务条款的损害补偿费用等。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>十二、结束服务</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （一）平台可随时根据实际情况中断一项或多项网络服务。平台不需对任何个人或第三方负责而随时中断服务。用户对后来的条款修改有异议，或对平台的服务不满，可以行使如下权利：\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    1、停止使用平台的网络服务；\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    2、通告平台停止对该用户的服务。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （二）结束用户服务后，用户使用网络服务的权利马上中止。从那时起，用户有权利，平台也没有义务传送任何未处理的信息或未完成的服务给户或第三方。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>十三、通告</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    所有发给用户的通告都可通过重要页面的公告或电子邮件或常规的信件传送。服务条款的修改、服务变更、或其它重要事件的通告都会以此形式进行。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>十四、参与广告策划</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    用户在他们发表的信息中加入宣传资料或参与广告策划，在本平台的免费服务上展示他们的招商条件等，任何这类宣传方法，只是在相应的用户和入驻商户之间发生。平台不承担任何责任，平台没有义务为这类广告负任何责任。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>十五、网络服务内容的所有权</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （一）平台定义的网络服务内容包括：文字、软件、声音、图片、录像、图表、广告中的全部内容；电子邮件的全部内容；本平台为用户提供的其他信息。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （二）所有这些内容受版权、商标、标签和其它财产所有权法律的保护。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （三）所以，用户只能在本平台和广告商授权下才能使用这些内容，而不能擅自复制、再造这些内容、或创造与内容有关的派生产品。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （四）平台所有的文章版权归原文作者和平台共同所有，任何人需要转载本平台的文章，必须征得原文作者或平台授权。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    <strong>十六、法律及管辖</strong>\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （一）网络服务条款要与中华人民共和国的法律解释相一致，用户和平台一致同意服从高等法院所有管辖。如发生平台服务条款与中华人民共和国法律相抵触时，则这些条款将完全按法律规定重新解释，而其它条款则依旧保持对用户产生法律效力和影响。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （二）因本用户协议产生纠纷的，用户可向网络服务提供者_______________人民法院提起诉讼。\r\n</p>\r\n<p style=\"text-indent: 2em;\">\r\n    （三）一经注册成为本网站的用户，即代表同意签署本用户协议并愿意遵守相关条款约束。\r\n</p>', '29', '9', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('66', '6', 'weixin_line', '微信公众号', '', '1', '0', '', '微信支付必须设置以下参数：必须为服务号，且通过认证', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('67', '6', 'weixin_appid', '开发者ID', '', '3', '1', '', '在微信公众号官方平台中：【设置与开发菜】菜单下的【基本配置】', '1', '0', '1', '1', '1', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('68', '6', 'weixin_secret', '开发者密码', '', '5', '1', '', '在微信公众号官方平台中：【设置与开发菜】菜单下的【基本配置】', '1', '0', '1', '1', '1', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('69', '6', 'weixin_openid', '获取微信Openid', '0', '7', '6', '开启|1,关闭|0', '微信APP里内访问自动获取OpenID', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('70', '6', 'weixin_openid_type', '获取方式', '0', '9', '6', '授权获取|1,静默获取|0', '外站获取时，本设置无效', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('71', '6', 'weixin_openid_url', '获取链接', '', '11', '1', '', '本站获取请留空，外站获取格式：http://www.baidu.com（用于多个站使用同一个微信服务号）', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('72', '6', 'sms_line', '短信设置', '', '13', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('73', '6', 'sms_state', '短信接口', '', '15', '11', '', '', '1', '0', '1', '1', '0', 'cms_plug', '', 'state=1 and type=&#039;sms&#039;', 'id desc', 'root', 'name');
INSERT INTO `cms_config` VALUES ('74', '6', 'sms_admin', '管理员手机号', '', '17', '1', '', '用于接收发货提醒等操作', '1', '0', '1', '1', '1', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('75', '6', 'auth_line', '实名认证接口', '', '19', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('76', '6', 'auth_state', '认证接口', '', '21', '11', '', '', '1', '0', '1', '1', '0', 'cms_plug', '', 'state=1 and type=&#039;auth&#039;', '', 'root', 'name');
INSERT INTO `cms_config` VALUES ('77', '6', 'auth_times', '错误限制', '3', '23', '1', '', '允许尝试的最多次数，为0时不限制', '1', '0', '1', '1', '1', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('78', '6', 'cash_line', '提现接口', '', '25', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('79', '6', 'cash_state', '提现接口', '', '27', '11', '', '不设置时，为手工打款', '1', '0', '1', '1', '0', 'cms_plug', '', 'state=1 and type=&#039;cash&#039;', '', 'root', 'name');
INSERT INTO `cms_config` VALUES ('86', '7', 'sys_temp_line', '系统模板', '', '13', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('87', '7', 'theme_dir', '模板路径', 'default', '15', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('88', '7', 'sys_plug', '插件列表', '[]', '17', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('89', '8', 'share_line', '分销设置', '', '1', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('90', '8', 'share_lever', '分销层级', '3', '3', '8', '关闭分销|0,开启一级|1,开启二级|2,开启三级|3', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('91', '8', 'share_lever_1', '一级分销比例', '45', '5', '1', '', '获得的百分比，输入1-100之间的数字', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('92', '8', 'share_lever_2', '二级分销比例', '35', '7', '1', '', '获得的百分比，输入1-100之间的数字', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('93', '8', 'share_lever_3', '三级分销比例', '20', '9', '1', '', '获得的百分比，输入1-100之间的数字', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('94', '8', 'comment_line', '评论设置', '', '11', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('95', '8', 'comment_state', '评论开关', '1', '13', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('96', '8', 'comment_times', '评论时间限制', '1', '15', '1', '', '多少分钟内只允许提交一次，为0时不限制', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('97', '8', 'comment_show', '评论审核', '0', '17', '6', '需要审核|0,直接通过|1', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('98', '8', 'comment_city', '某某网友', '极品模板', '19', '1', '', '根据IP地址找不到省市时候，显示的内容', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('99', '8', 'comment_reply', '回复自己', '0', '21', '6', '允许回复|1,不允许|0', '是否允许回复自己的评论', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('100', '9', 'admin_line', '后台设置', '', '1', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('101', '9', 'admin_logo', '后台Logo', '/public/admin/images/logo.png', '3', '4', '', '', '1', '1', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('102', '9', 'admin_code', '登录验证码', '1', '5', '6', '图形验证码|1,谷歌验证码|2,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('103', '9', 'admin_code_google', '谷歌密钥', '', '7', '1', '', '如果使用：谷歌验证码，请点击【生成】按钮生成密钥，然后通过【身份验证器】APP，扫描二维码', '1', '0', '1', '1', '1', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('104', '9', 'admin_logintimes', '登录尝试次数', '6', '9', '1', '', '超过次数后禁止登录', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('105', '9', 'admin_log', '自动清理日志', '30', '11', '1', '', '单位：天，超过多少天的自动清理', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('106', '9', 'admin_log_login', '后台登录日志', '1', '13', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('107', '9', 'admin_log_admin', '后台管理日志', '1', '15', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('108', '9', 'admin_title', '标题重复', '1', '17', '6', '检测|1,不检测|0', '检测内容标题是否重复', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('109', '9', 'admin_delete', '删除权限', '0', '19', '6', '可以删除|1,禁止删除|0', '普通管理员删除内容的权限', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('114', '9', 'content_line', '内容相关', '', '29', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('115', '9', 'side_class', '副栏目', '0', '31', '6', '开启|1,关闭|0', '添加内容时，发到其他栏目', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('116', '9', 'pay_way', '收费方式', '1', '33', '6', '免费|1,VIP免费|2,收费|3', '添加内容时，默认选中项', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('117', '9', 'video_type', '视频类型', '1', '35', '6', '单个视频|0,视频集|1', '添加视频内容时，默认选中项', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('118', '9', 'down_type', '下载类型', '0', '37', '6', '本地资源|0,网盘资源|1', '添加下载内容时，默认选中项', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('119', '8', 'other_line', '其他设置', '', '23', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('120', '8', 'author', '作者名称', '创始人', '25', '1', '', '前台显示的作者名称，当内容为后台发布时显示', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('121', '8', 'money', '货币单位', '元', '27', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('122', '9', 'discount_type', '折扣开关', '1', '39', '6', '开启|1,关闭|0', '添加内容时，是否显示折扣设置', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('123', '8', 'share_user', '会员升级分销比例', '0', '10', '1', '', '请输入0-100直接的数字，不建议大于30，为0时不分销。', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('126', '9', 'admin_notice', '官网通知', '0', '15', '6', '开启|1,关闭|0', '关闭后，后台不显示官网的通知', '0', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config_group` VALUES ('1', '基本设置', '1', '0', '1', '1');
INSERT INTO `cms_config_group` VALUES ('2', 'SEO设置', '3', '0', '1', '1');
INSERT INTO `cms_config_group` VALUES ('3', '附件设置', '5', '0', '1', '1');
INSERT INTO `cms_config_group` VALUES ('4', '手机站', '7', '0', '1', '1');
INSERT INTO `cms_config_group` VALUES ('5', '会员设置', '9', '0', '1', '1');
INSERT INTO `cms_config_group` VALUES ('6', '接口设置', '11', '0', '1', '1');
INSERT INTO `cms_config_group` VALUES ('7', '内置设置', '0', 'sys', '1', '1');
INSERT INTO `cms_config_group` VALUES ('8', '前台相关', '13', '0', '1', '1');
INSERT INTO `cms_config_group` VALUES ('9', '后台相关', '15', '0', '1', '1');
INSERT INTO `cms_user_group` VALUES ('1', '普通会员', '0', '0', '0', '0.00', '0', '0', '1', '1', '0', '100.00');
INSERT INTO `cms_user_group` VALUES ('2', '月付会员', '0', '0', '1', '98.00', '2', '1', '1', '1', '0', '90.00');
INSERT INTO `cms_user_group` VALUES ('3', '季度会员', '0', '0', '5', '198.00', '2', '3', '1', '1', '0', '80.00');
INSERT INTO `cms_user_group` VALUES ('4', '年度会员', '0', '0', '10', '598.00', '3', '1', '1', '1', '0', '70.00');
INSERT INTO `cms_user_group` VALUES ('5', '终身会员', '0', '0', '9999', '998.00', '4', '0', '1', '1', '0', '60.00');